/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.server;

import com.google.common.base.Suppliers;
import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.circuit.CircuitHelper;
import com.technicalitiesmc.scm.circuit.server.Circuit;
import com.technicalitiesmc.scm.circuit.server.CircuitTile;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.component.misc.LevelIOComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class ComponentInstance {
    private static final Supplier<IForgeRegistry<ComponentType>> TYPE_REGISTRY = Suppliers.memoize(() -> RegistryManager.ACTIVE.getRegistry(ComponentType.class));
    private final CircuitTile tile;
    private final ComponentPos pos;
    private final CircuitComponent component;
    private final List<Runnable> externalStateUpdates = new ArrayList<Runnable>();
    private Vec3i absolutePos;
    private ComponentState state;
    private VoxelShape shape;

    public ComponentInstance(CircuitTile tile, ComponentPos pos, ComponentType.Factory factory) {
        this.tile = tile;
        this.pos = pos;
        this.component = factory.create((ComponentContext)new Context());
        this.updatePosition();
        this.updateState();
    }

    public ComponentType getType() {
        return this.component.getType();
    }

    public ComponentSlot getSlot() {
        return this.component.getType().getSlot();
    }

    public ComponentSlot[] getAllSlots() {
        return this.component.getType().getAllSlots();
    }

    public ComponentState getState() {
        return this.state;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public Vec3i getPosition() {
        return this.absolutePos;
    }

    public boolean isLevelIOComponent() {
        return this.component instanceof LevelIOComponent;
    }

    private boolean updateState() {
        ComponentState newState = this.component.getState();
        boolean changed = !newState.equals((Object)this.state);
        this.state = newState;
        this.shape = CircuitHelper.createShape(this.component.getBoundingBox(), this.pos, this.getSlot());
        return changed;
    }

    public void updatePosition() {
        this.absolutePos = this.tile != null ? this.tile.getPosition().pack(this.pos) : null;
    }

    public void onAdded() {
        this.component.onAdded();
    }

    public void beforeRemove() {
        this.component.beforeRemove();
    }

    public void update(ComponentEventMap events, boolean tick) {
        this.component.update(events, tick);
    }

    public void updateSequential() {
        this.component.updateSequential();
    }

    public void updateExternalState() {
        this.externalStateUpdates.forEach(Runnable::run);
        this.externalStateUpdates.clear();
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        return this.component.use(player, hand, sideHit, hit);
    }

    public void spawnDrops(ComponentHarvestContext context) {
        this.component.spawnDrops(context);
    }

    public void harvest(ComponentHarvestContext context) {
        this.component.harvest(context);
    }

    public void receiveEvent(VecDirection side, CircuitEvent event, ComponentEventMap.Builder builder) {
        this.component.receiveEvent(side, event, builder);
    }

    public int getStrongOutput(VecDirection side) {
        RedstoneSource source = (RedstoneSource)this.component.getInterface(side, RedstoneSource.class);
        return source != null ? source.getStrongOutput() : 0;
    }

    public ItemStack getPickedItem() {
        return this.component.getPickedItem();
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("type", this.getType().getRegistryName().toString());
        tag.m_128365_("component", (Tag)this.component.save(new CompoundTag()));
        return tag;
    }

    @Nullable
    public static ComponentInstance load(CircuitTile tile, ComponentPos pos, CompoundTag tag) {
        ResourceLocation typeName = new ResourceLocation(tag.m_128461_("type"));
        ComponentType type = (ComponentType)TYPE_REGISTRY.get().getValue(typeName);
        if (type == null) {
            return null;
        }
        CompoundTag data = tag.m_128469_("component");
        return new ComponentInstance(tile, pos, ctx -> {
            CircuitComponent component = type.create(ctx);
            component.load(data);
            return component;
        });
    }

    private class Context
    implements ComponentContext {
        private Context() {
        }

        private Circuit getCircuit() {
            return ComponentInstance.this.tile.getCircuit();
        }

        public boolean isValidPosition(Vec3i offset) {
            Vec3i pos = ComponentInstance.this.absolutePos.m_141952_(offset);
            return this.getCircuit().isValidPosition(pos);
        }

        public boolean isTopSolid(Vec3i offset) {
            Vec3i pos = ComponentInstance.this.absolutePos.m_141952_(offset);
            if (pos.m_123342_() == -1) {
                return true;
            }
            ComponentInstance ci = this.getCircuit().get(pos, ComponentSlot.SUPPORT);
            return ci != null && ci.component.isTopSolid();
        }

        public CircuitComponent getComponentAt(Vec3i offset, ComponentSlot slot) {
            Vec3i pos = ComponentInstance.this.absolutePos.m_141952_(offset);
            ComponentInstance ci = this.getCircuit().get(pos, slot);
            return ci != null ? ci.component : null;
        }

        public void removeComponentAt(Vec3i offset, ComponentSlot slot, boolean notify) {
            Vec3i pos = ComponentInstance.this.absolutePos.m_141952_(offset);
            Circuit circuit = this.getCircuit();
            if (circuit.tryRemove(pos, slot) && notify) {
                circuit.sendEvent(pos, slot, CircuitEvent.NEIGHBOR_CHANGED, VecDirectionFlags.all());
            }
        }

        public void scheduleRemoval() {
            this.getCircuit().scheduleRemoval(ComponentInstance.this.absolutePos, ComponentInstance.this.getSlot());
        }

        public void sendEventAt(Vec3i offset, ComponentSlot slot, CircuitEvent event, VecDirectionFlags directions) {
            Vec3i pos = ComponentInstance.this.absolutePos.m_141952_(offset);
            this.getCircuit().sendEvent(pos, slot, event, directions);
        }

        public void updateExternalState(boolean reRender, Runnable action) {
            if (ComponentInstance.this.component == null || !this.getCircuit().isTicking()) {
                action.run();
                if (ComponentInstance.this.component != null && reRender && ComponentInstance.this.updateState()) {
                    ComponentInstance.this.tile.markForUpdate(ComponentInstance.this.pos, ComponentInstance.this.getSlot());
                }
                return;
            }
            this.getCircuit().enqueueStateUpdate(ComponentInstance.this.absolutePos, ComponentInstance.this.getSlot());
            ComponentInstance.this.externalStateUpdates.add(action);
            if (reRender) {
                ComponentInstance.this.externalStateUpdates.add(() -> {
                    if (ComponentInstance.this.updateState()) {
                        ComponentInstance.this.tile.markForUpdate(ComponentInstance.this.pos, ComponentInstance.this.getSlot());
                    }
                });
            }
        }

        public void scheduleSequential() {
            this.getCircuit().enqueueSequentialUpdate(ComponentInstance.this.absolutePos, ComponentInstance.this.getSlot());
        }

        public void scheduleTick(int delay) {
            this.getCircuit().enqueueTick(ComponentInstance.this.absolutePos, ComponentInstance.this.getSlot(), delay);
        }

        public void playSound(SoundEvent sound, SoundSource source, float volume, float pitch) {
            this.getCircuit().playSound(ComponentInstance.this.absolutePos, sound, source, volume, pitch);
        }
    }
}

